  import javafx.application.Application;
  import javafx.event.ActionEvent;
  import javafx.geometry.Insets;
  import javafx.scene.Scene;
  import javafx.scene.control.*;
  import javafx.scene.layout.VBox;
  import javafx.stage.Stage;

  public class ColorPickerDemo extends Application 
  {
     ColorPicker aColorPicker= new ColorPicker(Color.ORANGE);
     Button pickColor, likeColor;
     VBox root;
    
     @Override
     public void start(Stage primaryStage) 
     {
        root = new VBox();
        pickColor = new Button("Pick Color");
        likeColor = new Button("Like Color");

        aColorPicker.setOnAction(e-> handle(e));
        pickColor.setOnAction(e-> handle(e));
        likeColor.setOnAction(e-> handle(e));
        
        root.setAlignment(Pos.CENTER);
        root.setSpacing(15.0);
        root.getChildren().addAll(pickColor, likeColor);
        
        Scene scene = new Scene(root, 400, 300);

        primaryStage.setTitle("Color Picker Demo");
        primaryStage.setScene(scene);
        primaryStage.show();
     }

     public void handle(ActionEvent e)
     {   
        if(e.getSource() == pickColor && 
           !root.getChildren().contains(aColorPicker))
        {
            root.getChildren().add(aColorPicker);
        }
        else if(e.getSource() == aColorPicker)
        {
            String c = aColorPicker.getValue().toString();
            c = # + c.substring(2,8);
            root.setStyle("-fx-background-color: " + c);
            root.getChildren().remove(aColorPicker);
        }
        else if(e.getSource() == likeColor &&
                !root.getChildren().contains(aColorPicker))
        {
            root.getChildren().removeAll(pickColor, likeColor); 
        }
     }
  
     public static void main(String[] args) 
     {
        launch(args);
     }
  }

